<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * حالات الدفع
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum PaymentStatus: string
{
    case UNPAID = 'unpaid'; // غير مدفوعة
    case PARTIAL = 'partial'; // مدفوعة جزئياً
    case PAID = 'paid'; // مدفوعة كاملة
    case OVERPAID = 'overpaid'; // دفع زائد

    public function label(): string
    {
        return match ($this) {
            self::UNPAID => 'غير مدفوعة',
            self::PARTIAL => 'مدفوعة جزئياً',
            self::PAID => 'مدفوعة',
            self::OVERPAID => 'دفع زائد',
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::UNPAID => 'red',
            self::PARTIAL => 'yellow',
            self::PAID => 'green',
            self::OVERPAID => 'purple',
        };
    }
}
