<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * طرق الدفع
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum PaymentMethod: string
{
    case CASH = 'cash';                       // نقد
    case BANK_TRANSFER = 'bank_transfer';     // تحويل بنكي
    case CHEQUE = 'cheque';                   // شيك
    case CREDIT_CARD = 'credit_card';         // بطاقة ائتمان
    case OTHER = 'other';                     // أخرى

    public function label(): string
    {
        return match ($this) {
            self::CASH => 'نقد',
            self::BANK_TRANSFER => 'تحويل بنكي',
            self::CHEQUE => 'شيك',
            self::CREDIT_CARD => 'بطاقة ائتمان',
            self::OTHER => 'أخرى',
        };
    }

    public function icon(): string
    {
        return match ($this) {
            self::CASH => 'heroicon-o-banknotes',
            self::BANK_TRANSFER => 'heroicon-o-building-library',
            self::CHEQUE => 'heroicon-o-document-text',
            self::CREDIT_CARD => 'heroicon-o-credit-card',
            self::OTHER => 'heroicon-o-ellipsis-horizontal',
        };
    }
}
