<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * حالات الدفع للطلبات الإلكترونية
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum OrderPaymentStatus: string
{
    case Initiated = 'initiated'; // تم البدء
    case Pending = 'pending';   // قيد الانتظار
    case Paid = 'paid';      // مدفوع
    case Failed = 'failed';    // فشل
    case Refunded = 'refunded';  // تم الاسترجاع
    case Canceled = 'canceled';  // ملغي

    public function label(): string
    {
        return match ($this) {
            self::Initiated => 'تم البدء',
            self::Pending => 'قيد الانتظار',
            self::Paid => 'مدفوع',
            self::Failed => 'فشل',
            self::Refunded => 'تم الاسترجاع',
            self::Canceled => 'ملغي',
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::Initiated => 'gray',
            self::Pending => 'warning',
            self::Paid => 'success',
            self::Failed => 'danger',
            self::Refunded => 'info',
            self::Canceled => 'gray',
        };
    }

    public function icon(): string
    {
        return match ($this) {
            self::Initiated => 'heroicon-o-play',
            self::Pending => 'heroicon-o-clock',
            self::Paid => 'heroicon-o-check-circle',
            self::Failed => 'heroicon-o-x-circle',
            self::Refunded => 'heroicon-o-arrow-uturn-left',
            self::Canceled => 'heroicon-o-no-symbol',
        };
    }

    public static function options(): array
    {
        return collect(self::cases())
            ->mapWithKeys(fn (self $status) => [$status->value => $status->label()])
            ->all();
    }

    /**
     * هل الدفع ناجح؟
     */
    public function isSuccessful(): bool
    {
        return $this === self::Paid;
    }

    /**
     * هل الدفع في حالة نهائية؟
     */
    public function isFinal(): bool
    {
        return in_array($this, [
            self::Paid,
            self::Refunded,
            self::Canceled,
        ]);
    }
}
