<?php

namespace App\Enums;

enum MovementDirection: string
{
    case IN  = 'IN';   // وارد: يضيف للرصيد
    case OUT = 'OUT';  // صادر: يخصم من الرصيد
    case ADJ = 'ADJ';  // تسوية: زيادة/نقص لتصحيح الجرد

    public function label(): string
    {
        return match ($this) {
            self::IN  => 'وارد',
            self::OUT => 'صادر',
            self::ADJ => 'تسوية',
        };
    }

    public function sign(?string $adjEffect = null): int
    {
        return match ($this) {
            self::IN  => +1,
            self::OUT => -1,
            self::ADJ => ($adjEffect === 'minus' ? -1 : +1),
        };
    }
}
