<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * أنواع الحركات في دفتر الأستاذ
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum LedgerType: string
{
    case PURCHASE   = 'purchase';           // فاتورة شراء
    case RETURN     = 'return';               // مرتجع
    case PAYMENT    = 'payment';             // دفعة
    case REFUND     = 'refund';               // استرداد
    case ADJUSTMENT = 'adjustment';       // تسوية

    public function label(): string
    {
        return match ($this) {
            self::PURCHASE      => 'فاتورة شراء',
            self::RETURN        => 'مرتجع',
            self::PAYMENT       => 'دفعة',
            self::REFUND        => 'استرداد',
            self::ADJUSTMENT    => 'تسوية',
        };
    }

    public function sign(): int
    {
        return match ($this) {
            self::PURCHASE      => 1,      // موجب (دائن للمورد)
            self::RETURN        => -1,       // سالب (مدين للمورد)
            self::PAYMENT       => -1,      // سالب (دفعة للمورد)
            self::REFUND        => 1,        // موجب (استرداد منه)
            self::ADJUSTMENT    => 0,    // حسب القيمة
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::PURCHASE      => 'blue',
            self::RETURN        => 'orange',
            self::PAYMENT       => 'green',
            self::REFUND        => 'purple',
            self::ADJUSTMENT    => 'gray',
        };
    }
}
