<?php

namespace App\Enums;

/**
 * نوع سند العميل:
 * - collection : قبض من العميل
 * - payment    : دفع / استرجاع للعميل
 */
enum ClientReceiptType: string
{
    case COLLECTION = 'collection';
    case PAYMENT    = 'payment';

    public function label(): string
    {
        return match ($this) {
            self::COLLECTION => 'قبض من العميل',
            self::PAYMENT    => 'دفع للعميل / استرجاع',
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::COLLECTION => 'success',
            self::PAYMENT    => 'warning',
        };
    }

    public static function options(): array
    {
        return [
            self::COLLECTION->value => self::COLLECTION->label(),
            self::PAYMENT->value    => self::PAYMENT->label(),
        ];
    }

    public static function values(): array
    {
        return array_map(fn($c) => $c->value, self::cases());
    }
}
