# نظام Product Configurator - دليل شامل

## 🎨 نظرة عامة

تم بناء نظام Product Configurator متكامل يسمح للعملاء بتخصيص المنتجات باستخدام موديلات ثلاثية الأبعاد (GLB) مع إمكانية:
- تغيير الألوان (خلفية وموديل)
- إضافة نصوص مخصصة
- رفع صور وتطبيقها على الموديل
- حفظ التصاميم ومشاركتها
- مكتبة تصاميم عامة
- نظام إعجابات ومشاهدات

---

## 📁 الهيكل الكامل

### 1. Database (الجداول)

#### `product_models` - جدول الموديلات 3D
```
- id
- product_id (FK to products)
- name
- description
- glb_file_path (مسار ملف GLB)
- available_options (JSON - الخيارات المتاحة)
- metadata (JSON - إعدادات الكاميرا، الإضاءة)
- is_active
- is_featured
- order
- views_count
- designs_count
- timestamps
- soft_deletes
```

#### `product_designs` - جدول التصاميم المخصصة
```
- id
- product_model_id (FK)
- user_id (FK - صاحب التصميم)
- order_item_id (FK - إذا تم الشراء)
- name
- configuration (JSON - كل التخصيصات)
- preview_image (صورة معاينة)
- is_public (عام أم خاص)
- is_featured
- views_count
- likes_count
- purchases_count
- timestamps
- soft_deletes
```

#### `product_design_likes` - جدول الإعجابات
```
- id
- product_design_id (FK)
- user_id (FK)
- created_at
```

---

### 2. Models

#### `App\Models\ProductModel`
**العلاقات:**
- `product()` - المنتج المرتبط
- `designs()` - جميع التصاميم
- `publicDesigns()` - التصاميم العامة فقط
- `featuredDesigns()` - التصاميم المميزة

**Scopes:**
- `active()` - الموديلات النشطة
- `featured()` - المميزة
- `popular()` - الأكثر استخداماً

**Media Collections:**
- `model_preview` - صور معاينة
- `model_glb` - ملف GLB

#### `App\Models\ProductDesign`
**العلاقات:**
- `productModel()` - الموديل المستخدم
- `user()` - المستخدم صاحب التصميم
- `orderItem()` - عنصر الطلب (إذا تم الشراء)
- `likedBy()` - المستخدمين الذين أعجبوا بالتصميم

**Methods:**
- `isLikedBy(User $user)` - تحقق من الإعجاب
- `toggleLike(User $user)` - تبديل الإعجاب
- `incrementViews()` - زيادة المشاهدات
- `incrementPurchases()` - زيادة عدد المشتريات

**Scopes:**
- `public()` - التصاميم العامة
- `featured()` - المميزة
- `popular()` - الأكثر مبيعاً
- `mostLiked()` - الأكثر إعجاباً

---

### 3. Controllers

#### `ConfiguratorController`
**Routes:**
```php
GET  /configurator/model/{model}          - عرض صفحة التخصيص
POST /configurator/model/{model}/save     - حفظ تصميم جديد
GET  /configurator/design/{design}        - تحميل تصميم موجود
PUT  /configurator/design/{design}        - تحديث تصميم
DELETE /configurator/design/{design}      - حذف تصميم
POST /configurator/design/{design}/like   - إعجاب/إلغاء إعجاب
```

#### `DesignLibraryController`
**Routes:**
```php
GET /designs                  - صفحة مكتبة التصاميم (عرض الموديلات)
GET /designs/gallery          - معرض التصاميم
GET /designs/{design}         - تفاصيل تصميم معين
```

---

### 4. Views

#### `resources/views/configurator/show.blade.php`
**الواجهة الرئيسية للتخصيص** - تحتوي على:

**القسم العلوي (Top Bar):**
- معلومات المنتج والموديل
- زر إعادة ضبط العرض
- زر التقاط صورة
- زر حفظ التصميم

**منطقة العرض الرئيسية (3D Canvas):**
- عرض الموديل ثلاثي الأبعاد
- تحكم بالكاميرا (تدوير، تكبير/تصغير)
- أدوات العرض (wireframe، دوران تلقائي)
- عداد FPS

**لوحة التحكم الجانبية:**
1. **تبويب الألوان:**
   - لون الخلفية (ألوان محددة مسبقاً + color picker)
   - لون الموديل (ألوان محددة مسبقاً + color picker)

2. **تبويب النصوص:**
   - إدخال نص مخصص
   - تعديل حجم النص
   - تغيير لون النص
   - حذف النص

3. **تبويب الصور:**
   - رفع صورة
   - تعديل حجم الصورة
   - حذف الصورة

4. **التصاميم الجاهزة:**
   - عرض تصاميم عامة للموديل
   - تحميل تصميم بنقرة واحدة

**Modal حفظ التصميم:**
- اسم التصميم
- جعله عاماً أو خاصاً
- حفظ صورة معاينة تلقائياً

#### `resources/views/design-library/index.blade.php`
**صفحة مكتبة التصاميم** - تحتوي على:

**Hero Section:**
- عنوان جذاب
- شريط بحث

**قسم التصاميم المميزة:**
- عرض 4 تصاميم مميزة
- معلومات التصميم (مشاهدات، إعجابات)

**قسم الأكثر طلباً:**
- عرض 8 تصاميم الأكثر مبيعاً
- عدد المشتريات لكل تصميم

**قسم الموديلات ثلاثية الأبعاد:**
- عرض جميع الموديلات المتاحة
- معلومات كل موديل (عدد التصاميم، المنتج المرتبط)
- معاينة 3 تصاميم لكل موديل
- زر "تخصيص الآن" مباشر
- فلاتر (الأحدث، الأكثر شعبية، المميزة)
- Pagination

---

## 🚀 كيفية الاستخدام

### 1. إضافة موديل 3D جديد (من لوحة التحكم)

```php
// سيتم إضافة Filament Resource قريباً
// في الوقت الحالي يمكن إضافة موديل من خلال:

$model = ProductModel::create([
    'product_id' => 1,
    'name' => 'موديل جوارب رياضية',
    'description' => 'موديل ثلاثي الأبعاد لجوارب رياضية',
    'glb_file_path' => 'models/sock.glb', // ضع الملف في storage/app/public/models/
    'available_options' => [
        'colors' => ['أحمر', 'أزرق', 'أخضر'],
        'parts' => ['toe', 'heel', 'ankle'],
    ],
    'metadata' => [
        'camera' => ['x' => 0, 'y' => 1, 'z' => 5],
        'lighting' => ['ambient' => 0.6, 'directional' => 0.8],
    ],
    'is_active' => true,
    'is_featured' => true,
]);

// رفع ملف GLB
$model->addMedia(storage_path('app/public/models/sock.glb'))
    ->toMediaCollection(ProductModel::MEDIA_COLLECTION_GLB);

// رفع صورة معاينة
$model->addMedia(storage_path('app/public/models/sock-preview.png'))
    ->toMediaCollection(ProductModel::MEDIA_COLLECTION_PREVIEW);
```

### 2. الوصول للصفحات

```
مكتبة التصاميم: https://nassaj.test/designs
صفحة التخصيص: https://nassaj.test/configurator/model/{model_id}
```

### 3. تدفق العمل للعميل

1. **زيارة مكتبة التصاميم**
   - تصفح الموديلات المتاحة
   - مشاهدة التصاميم المميزة والأكثر طلباً

2. **اختيار موديل وتخصيصه**
   - النقر على "تخصيص الآن"
   - تغيير الألوان (خلفية وموديل)
   - إضافة نص مخصص (اسم، رقم، رسالة)
   - رفع صورة (شعار، صورة شخصية)
   - اختبار تصميم جاهز

3. **حفظ التصميم**
   - إدخال اسم التصميم
   - اختيار جعله عاماً أو خاصاً
   - يتم حفظ صورة معاينة تلقائياً
   - يتم حفظ جميع التخصيصات في JSON

4. **مشاركة أو شراء**
   - مشاركة التصميم مع الآخرين (إذا كان عاماً)
   - إضافة التصميم للسلة والشراء
   - عند الشراء يتم ربط التصميم بعنصر الطلب

---

## 🔧 التخصيصات المحفوظة (Configuration JSON)

كل تصميم يحفظ configuration كـ JSON:

```json
{
  "backgroundColor": "#1a1a1a",
  "modelColor": "#FF6B6B",
  "text": {
    "content": "أحمد",
    "size": 1.5,
    "color": "#CCBF79"
  },
  "image": {
    "data": "data:image/png;base64,...",
    "scale": 1.2
  },
  "camera": {
    "position": [0, 1, 5],
    "rotation": [0, 0, 0]
  }
}
```

---

## 📊 الميزات المتقدمة

### 1. نظام الإعجابات
```php
// في أي مكان في الكود
$design->toggleLike($user);
$isLiked = $design->isLikedBy($user);
$likesCount = $design->likes_count;
```

### 2. تتبع المشاهدات
```php
// يتم تلقائياً عند عرض التصميم
$design->incrementViews();
$model->incrementViews();
```

### 3. تتبع المبيعات
```php
// عند إتمام طلب يحتوي على تصميم
$design->incrementPurchases();
```

### 4. التصاميم المميزة
```php
// في لوحة التحكم
$design->update(['is_featured' => true]);

// في الاستعلامات
$featuredDesigns = ProductDesign::featured()->get();
```

---

## 🎯 الخطوات التالية (للتطوير)

### 1. إكمال Filament Resource
- إضافة form لرفع ملفات GLB
- إدارة الموديلات (تفعيل/تعطيل، ترتيب)
- إدارة التصاميم (عرض، حذف، تمييز)

### 2. دمج مع نظام السلة
- إضافة زر "شراء التصميم" في صفحة التخصيص
- ربط التصميم بعنصر السلة
- عرض صورة التصميم في السلة والطلبات

### 3. تحسين Three.js
- إضافة FontLoader لدعم نصوص عربية أفضل
- إضافة دعم لأجزاء متعددة من الموديل
- إضافة textureLoader متقدم
- إضافة post-processing effects

### 4. صفحة تفاصيل التصميم
- إنشاء view لعرض تصميم واحد
- معلومات التصميم والمصمم
- تصاميم مشابهة
- أزرار مشاركة ومثل

### 5. لوحة تحكم العميل
- صفحة تصاميمي (My Designs)
- إحصائيات (مشاهدات، إعجابات)
- تعديل وحذف التصاميم

---

## 📝 ملاحظات مهمة

1. **ملفات GLB:**
   - يجب أن تكون الملفات محسّنة (< 5MB)
   - استخدام Draco compression عند الإمكان
   - التأكد من الـ textures مضمّنة في الملف

2. **الأداء:**
   - Three.js يعمل client-side
   - قد يكون بطيئاً على أجهزة ضعيفة
   - يُفضل عرض loading screen أثناء تحميل الموديل

3. **الصور المحفوظة:**
   - صور المعاينة تُحفظ في `storage/app/public/designs/`
   - يجب عمل `php artisan storage:link` لربط المجلد

4. **Policies:**
   - تم إضافة ProductDesignPolicy
   - فقط صاحب التصميم يمكنه تعديله/حذفه
   - التصاميم العامة يمكن للجميع مشاهدتها

---

## 🎨 التصميم والألوان

النظام يستخدم ألوان نساج الموحدة:
- `nassaj-gold`: #CCBF79
- `nassaj-gold-light`: #D9CE93
- `nassaj-primary`: #442247

جميع الواجهات responsive وتدعم Dark Mode.

---

## ✅ تم الإنجاز

- ✅ Migrations (product_models, product_designs, product_design_likes)
- ✅ Models مع جميع العلاقات والـ Scopes
- ✅ Controllers (ConfiguratorController, DesignLibraryController)
- ✅ Routes كاملة
- ✅ Views (صفحة التخصيص، مكتبة التصاميم)
- ✅ Three.js integration كامل
- ✅ نظام حفظ التصاميم مع صور معاينة
- ✅ نظام الإعجابات والمشاهدات
- ✅ Policy للتحكم بالصلاحيات
- ✅ تحديث Quick View Modal بتصميم جديد
- ✅ إضافة رابط في القائمة الرئيسية

---

## 📞 للدعم

في حال وجود أي استفسارات أو مشاكل:
1. راجع هذا الملف أولاً
2. تحقق من logs في `storage/logs/`
3. تحقق من console في المتصفح (F12)

**ملاحظة:** النظام جاهز للاستخدام الفوري بعد رفع ملفات GLB!
