# دليل صفحة العروض الخاصة

## نظرة عامة

تم إضافة نظام كامل لإدارة العروض والخصومات على المنتجات في المتجر.

## المميزات

### 1. صفحة العروض (`/offers`)
- عرض جميع المنتجات التي عليها عروض نشطة
- فلترة حسب التصنيف والماركة
- ترتيب حسب:
  - الأحدث
  - الخصم الأعلى
  - السعر (من الأقل للأعلى / من الأعلى للأقل)
  - الاسم (أ-ي / ي-أ)

### 2. حقول الخصومات الجديدة
تم إضافة الحقول التالية إلى جدول `product_prices`:

| الحقل | النوع | الوصف |
|------|------|------|
| `is_on_sale` | boolean | هل المنتج عليه عرض؟ |
| `discount_percentage` | integer | نسبة الخصم (0-100) |
| `sale_price` | integer | السعر بعد الخصم |
| `sale_start_date` | timestamp | تاريخ بداية العرض |
| `sale_end_date` | timestamp | تاريخ نهاية العرض |

### 3. عرض الخصومات
- يتم عرض نسبة الخصم كـ badge على بطاقات المنتجات
- يتم عرض السعر القديم مشطوب والسعر الجديد بلون مميز
- الخصومات تظهر تلقائياً في جميع صفحات المنتجات

## كيفية إضافة عرض على منتج

### عبر Filament Admin Panel:
1. اذهب إلى `Product Prices` في لوحة التحكم
2. اختر السعر المراد تطبيق عرض عليه
3. فعّل خيار `Is On Sale`
4. أدخل نسبة الخصم أو السعر الجديد
5. حدد تاريخ البداية والنهاية (اختياري)
6. احفظ التغييرات

### عبر Tinker:
```php
use App\Models\ProductPrice;

// جلب السعر
$price = ProductPrice::find(1);

// تطبيق عرض 25%
$price->update([
    'is_on_sale' => true,
    'discount_percentage' => 25,
    'sale_price' => (int)($price->retail_price * 0.75),
    'sale_start_date' => now(),
    'sale_end_date' => now()->addDays(30),
]);
```

### عبر Seeder (لأغراض الاختبار):
```bash
php artisan db:seed --class=OffersSeeder
```

## التحقق من العروض النشطة

### في Blade:
```php
@if($product->prices()->onSale()->exists())
    <span class="badge">عرض خاص</span>
@endif
```

### في Controller:
```php
// جلب المنتجات التي عليها عروض
$products = Product::whereHas('prices', fn($q) => $q->onSale())->get();
```

### في Model:
```php
// ProductPrice Model
$price->isOnSale(); // true/false

// الحصول على السعر النهائي مع الخصم
$finalPrice = $price->getFinalPrice('retail');
```

## API Endpoints

### جلب المنتجات التي عليها عروض
```
GET /api/store/offers

Parameters:
- category (optional): فلترة حسب التصنيف
- brand (optional): فلترة حسب الماركة
- search (optional): البحث
- sort (optional): الترتيب
  - newest (الأحدث)
  - discount_high (الخصم الأعلى)
  - price_asc (السعر تصاعدياً)
  - price_desc (السعر تنازلياً)
  - name_asc (الاسم أ-ي)
  - name_desc (الاسم ي-أ)
- per_page (optional): عدد النتائج في الصفحة

Response:
{
    "success": true,
    "products": [...],
    "pagination": {
        "current_page": 1,
        "last_page": 5,
        "per_page": 24,
        "total": 120
    }
}
```

## ملاحظات مهمة

1. **التحقق من الفترة الزمنية**: العروض تظهر فقط إذا كان التاريخ الحالي بين `sale_start_date` و `sale_end_date`
2. **الأسعار بالدينار العراقي**: جميع الأسعار مخزنة كأرقام صحيحة (integers)
3. **أنواع العملاء**: يتم عرض السعر حسب نوع العميل (retail للأفراد، wholesale للشركات)
4. **الأولوية**: إذا كان `sale_price` موجود، يتم استخدامه. وإلا يتم حساب السعر بناءً على `discount_percentage`

## الاختبار

لاختبار صفحة العروض:

1. تأكد من وجود منتجات في قاعدة البيانات
2. قم بتشغيل Seeder لإضافة عروض تجريبية:
   ```bash
   php artisan db:seed --class=OffersSeeder
   ```
3. افتح المتصفح وانتقل إلى: `https://nassaj.test/offers`
4. تأكد من ظهور المنتجات مع نسب الخصومات
5. جرب الفلاتر والترتيب

## الصيانة

### لإزالة العروض المنتهية تلقائياً:
يمكنك إنشاء command مجدول:

```php
// app/Console/Commands/ExpireOffers.php
use App\Models\ProductPrice;

ProductPrice::where('is_on_sale', true)
    ->where('sale_end_date', '<', now())
    ->update(['is_on_sale' => false]);
```

## الدعم

في حالة وجود مشاكل:
1. تأكد من تشغيل migration: `php artisan migrate`
2. تأكد من وجود بيانات في `product_prices`
3. تحقق من أن العروض ضمن الفترة الزمنية الصحيحة
