# 📦 دليل رفع ملفات GLB - Product Configurator

## الطريقة 1: عبر لوحة التحكم Filament (الأسهل والأفضل) ⭐

### الخطوات:

#### 1. الدخول إلى لوحة التحكم
```
https://nassaj.test/admin
```

#### 2. الانتقال إلى "الموديلات 3D"
- من القائمة الجانبية اختر **"المنتجات"**
- ثم اختر **"الموديلات 3D"**

#### 3. إنشاء موديل جديد
انقر على زر **"إنشاء موديل 3D"** في الأعلى

#### 4. ملء النموذج

**أ. معلومات أساسية:**
- **المنتج:** اختر المنتج الذي سيرتبط بهذا الموديل (مثل: جوارب رياضية)
- **اسم الموديل:** أدخل اسماً واضحاً (مثل: موديل جوارب رياضية 3D)
- **الوصف:** وصف مختصر للموديل (اختياري)

**ب. ملفات الموديل:**
- **ملف الموديل (GLB):** ⭐ هنا ترفع ملف GLB الخاص بك
  - انقر على "Choose file" أو اسحب الملف
  - الحد الأقصى: 10MB
  - يجب أن يكون بصيغة `.glb`
  
- **صورة المعاينة:** صورة لمعاينة الموديل (اختياري)
  - يمكنك رفع صورة PNG/JPG
  - الحد الأقصى: 5MB

**ج. الحالة والإعدادات:**
- ☑️ **نشط:** اجعله محدداً لعرض الموديل في المتجر
- ☑️ **مميز:** حدده إذا كنت تريد عرضه كموديل مميز
- **الترتيب:** رقم الترتيب (الأقل يظهر أولاً)

#### 5. الحفظ
انقر على **"إنشاء"** في الأسفل

#### 6. التحقق
بعد الحفظ:
- ستظهر رسالة نجاح
- يمكنك النقر على "معاينة في المتجر" لرؤية الموديل

---

## الطريقة 2: عبر Tinker (للمطورين)

### الخطوات:

#### 1. فتح Tinker
```bash
php artisan tinker
```

#### 2. وضع ملف GLB في المكان الصحيح
أولاً، ضع ملف GLB في:
```
storage/app/public/models/your-model.glb
```

#### 3. إنشاء الموديل
```php
$model = \App\Models\ProductModel::create([
    'product_id' => 1, // معرف المنتج الموجود
    'name' => 'موديل جوارب رياضية',
    'description' => 'موديل ثلاثي الأبعاد قابل للتخصيص',
    'is_active' => true,
    'is_featured' => true,
    'order' => 1,
]);
```

#### 4. رفع ملف GLB
```php
$model->addMedia(storage_path('app/public/models/your-model.glb'))
    ->toMediaCollection(\App\Models\ProductModel::MEDIA_COLLECTION_GLB);
```

#### 5. رفع صورة معاينة (اختياري)
```php
$model->addMedia(storage_path('app/public/models/preview.png'))
    ->toMediaCollection(\App\Models\ProductModel::MEDIA_COLLECTION_PREVIEW);
```

#### 6. التحقق
```php
$model->glb_url; // سيعرض رابط ملف GLB
$model->preview_image_url; // سيعرض رابط صورة المعاينة
```

---

## 📝 ملاحظات مهمة

### متطلبات ملف GLB:
1. ✅ **الحجم:** يُفضل أقل من 5MB (الحد الأقصى 10MB)
2. ✅ **التحسين:** استخدم أدوات تحسين مثل:
   - [gltf-pipeline](https://github.com/CesiumGS/gltf-pipeline)
   - [gltf.report](https://gltf.report/)
3. ✅ **Draco Compression:** يُفضل استخدام ضغط Draco
4. ✅ **Textures:** تأكد أن جميع الـ textures مضمّنة في الملف
5. ✅ **Scale:** تأكد من حجم الموديل مناسب (سيتم تعديله تلقائياً)

### نصائح للأداء:
- 🎯 استخدم موديلات بسيطة (Low-poly)
- 🎯 قلل عدد المثلثات (Triangles/Polygons)
- 🎯 حجّم الـ textures بشكل مناسب (512x512 أو 1024x1024)
- 🎯 احذف الأجزاء غير المرئية من الموديل

### تحويل ملفات 3D إلى GLB:
إذا كان لديك ملف بصيغة أخرى (FBX, OBJ, GLTF):

**باستخدام Blender (مجاني):**
1. افتح الملف في Blender
2. File → Export → glTF 2.0 (.glb)
3. في خيارات التصدير:
   - Format: GLB
   - Compression: Draco (إذا متوفر)
   - Apply Modifiers: ✓
4. Export

**أدوات أونلاين:**
- [glTF-Transform](https://gltf-transform.dev/)
- [3D Model Converter](https://imagetostl.com/convert/file/gltf/to/glb)

---

## 🔍 التحقق من الموديل

### عبر لوحة التحكم:
1. اذهب إلى **"الموديلات 3D"**
2. ستجد الموديل في القائمة
3. انقر على أيقونة العين (👁️) للمعاينة في المتجر

### عبر المتجر:
1. اذهب إلى: `https://nassaj.test/designs`
2. يجب أن يظهر الموديل في قائمة الموديلات
3. انقر على **"تخصيص الآن"**
4. سيفتح Product Configurator مع الموديل

---

## ❓ حل المشاكل الشائعة

### المشكلة: "الملف كبير جداً"
**الحل:**
```bash
# قم بتحسين الملف باستخدام gltf-pipeline
npm install -g gltf-pipeline
gltf-pipeline -i input.glb -o output.glb -d
```

### المشكلة: "الموديل لا يظهر في Product Configurator"
**الحل:**
1. تحقق من أن الموديل **نشط** (is_active = true)
2. تحقق من رابط GLB:
```php
php artisan tinker
$model = \App\Models\ProductModel::find(1);
$model->glb_url; // يجب أن يعرض رابط صحيح
```
3. افتح console المتصفح (F12) وتحقق من أي أخطاء

### المشكلة: "الموديل يظهر بشكل غريب"
**الحل:**
- تحقق من Scale و Position في Blender قبل التصدير
- تأكد من Reset Transform في Blender (Ctrl+A → All Transforms)

---

## 📊 مثال عملي كامل

### السيناريو: رفع موديل جوارب رياضية

#### الخطوة 1: تحضير الملف
```
اسم الملف: sports-sock.glb
الحجم: 3.2 MB
الموقع: storage/app/public/models/sports-sock.glb
```

#### الخطوة 2: رفع عبر Filament
1. الدخول لـ `/admin`
2. المنتجات → الموديلات 3D → إنشاء
3. ملء البيانات:
   - المنتج: "جوارب رياضية"
   - الاسم: "موديل جوارب رياضية 3D"
   - الوصف: "موديل ثلاثي الأبعاد قابل للتخصيص بالكامل"
   - رفع ملف GLB
   - رفع صورة معاينة
   - ✓ نشط
   - ✓ مميز
4. حفظ

#### الخطوة 3: اختبار
1. زيارة: `https://nassaj.test/designs`
2. البحث عن الموديل
3. النقر على "تخصيص الآن"
4. اختبار جميع الميزات:
   - تغيير الألوان ✓
   - إضافة نص ✓
   - رفع صورة ✓
   - حفظ التصميم ✓

---

## 🎯 الخطوات التالية

بعد رفع الموديل بنجاح:

1. ✅ **اختبر جميع الميزات** في Product Configurator
2. ✅ **أنشئ تصاميم عامة** لتظهر في مكتبة التصاميم
3. ✅ **شارك الرابط** مع العملاء
4. ✅ **راقب الإحصائيات** (مشاهدات، تصاميم)

---

## 📞 الدعم

إذا واجهت أي مشكلة:
1. تحقق من `storage/logs/laravel.log`
2. افتح Console المتصفح (F12)
3. تحقق من صلاحيات المجلدات:
```bash
chmod -R 755 storage/app/public
php artisan storage:link
```

---

## ✅ Checklist للتأكد

- [ ] ملف GLB محسّن (< 5MB)
- [ ] Textures مضمّنة في الملف
- [ ] Scale مناسب في Blender
- [ ] الموديل مرفوع عبر Filament
- [ ] صورة معاينة مضافة
- [ ] الموديل نشط (is_active)
- [ ] تم الاختبار في Configurator
- [ ] جميع الميزات تعمل بشكل صحيح

**الآن أنت جاهز لرفع موديلات 3D بنجاح! 🎉**
