# 🎨 Nassaj Store - تصميم واجهة المتجر الإلكتروني

## 📐 نظرة عامة على التصميم

تصميم متجر إلكتروني عصري وفاخر لبيع الجوارب والمنسوجات، يجمع بين الأناقة العربية والحداثة، مع التركيز على تجربة مستخدم سلسة وجذابة بصرياً.

---

## 🎨 نظام الألوان (Color Palette)

### الألوان الأساسية
- **الذهبي الفاخر (Primary Gold)**: `#CCBF79` - `#a89958` (Gradient)
  - يستخدم في الأزرار الرئيسية، العناوين المهمة، والعناصر التفاعلية
  - يعكس الفخامة والجودة العالية

- **البنفسجي الداكن (Deep Purple)**: `#8b4789` - `#6b3568` (Gradient)
  - للعناصر الثانوية والمنتجات القابلة للتخصيص
  - يضيف لمسة من الغموض والأناقة

- **الأسود والرمادي (Neutrals)**:
  - خلفية داكنة: `#1a1a1a` (Dark Mode)
  - نصوص: `#f5f5f5` (فاتح) / `#1a1a1a` (داكن)
  - خلفيات البطاقات: شبه شفاف مع blur effect

### ألوان الحالة (Status Colors)
- **أحمر الخصم (Sale Red)**: `#e53e3e` - `#c53030` (Gradient)
- **أخضر النجاح**: `#38a169`
- **أزرق المعلومات**: `#3182ce`

### الوضع الداكن/الفاتح (Dark/Light Mode)
- دعم كامل للتبديل بين الوضعين
- انتقالات سلسة بين الأوضاع
- الألوان تتكيف تلقائياً

---

## 🏗️ بنية التصميم (Layout Structure)

### 1. الهيدر (Header)
```
┌─────────────────────────────────────────────────────────┐
│ [شعار نساج] [الرئيسية] [المتجر] [معرض] [اتصل]    │
│                                       [🌙] [🔍] [❤️] [🛒] │
└─────────────────────────────────────────────────────────┘
```

**مواصفات الهيدر:**
- خلفية شبه شفافة مع تأثير blur (backdrop-filter)
- يثبت في الأعلى عند التمرير (Sticky)
- ارتفاع: 70px
- الشعار: 120px عرض
- الأيقونات: 40px × 40px دائرية مع hover effect
- شريط علوي (Top Bar) للإعلانات والعروض بـ carousel

### 2. الصفحة الرئيسية (Hero Section)
```
┌─────────────────────────────────────────────────────────┐
│                                                          │
│     جوارب فاخرة                                        │
│     بأنامل عراقية                                      │
│                                                          │
│     [تسوق الآن] [استعرض التصاميم]                      │
│                                                          │
│            [صورة المنتج الرئيسي]                        │
└─────────────────────────────────────────────────────────┘
```

**خصائص Hero:**
- ارتفاع: 90vh
- خلفية gradient متحركة
- عناصر ديكورية: دوائر شبكية تتحرك ببطء
- عنوان كبير: font-size 52px، font-weight 800
- أزرار CTA بارزة مع shadows وanimations

### 3. بطاقات المنتجات (Product Cards)

#### التصميم الحديث (Modern Card Design)
```
┌───────────────────────────────┐
│  [Badge: خصم 12%]             │
│                                │
│     [صورة المنتج]              │
│                                │
│  [👁️ عرض] [📊 مقارنة] [❤️]   │ <- تظهر عند Hover
│                                │
├───────────────────────────────┤
│  Brand Name                    │
│  اسم المنتج الكامل            │
│  ⭐⭐⭐⭐⭐ (4.5)                │
│  ~~950,000 د.ع~~ 850,000 د.ع  │
│                                │
│ ┌───────────────────────────┐ │
│ │ 850,000 د.ع │ أضف للسلة  │ │
│ └───────────────────────────┘ │
└───────────────────────────────┘
```

**مواصفات البطاقة:**
- **أبعاد البطاقة**: 
  - عرض: responsive (4 أعمدة على الديسكتوب)
  - نسبة الصورة: 1:1 (مربع)
  - حواف: border-radius 16px

- **الصورة**:
  - تكبير عند hover: scale(1.1)
  - انتقال سلس: transition 0.6s
  - object-fit: cover

- **Badge (شارة الخصم/جديد)**:
  - موضع: أعلى اليمين (12px من الحواف)
  - شكل: دائري (border-radius 20px)
  - خلفية gradient:
    - خصم: أحمر (#e53e3e → #c53030)
    - جديد: ذهبي (#CCBF79 → #a89958)
  - حجم الخط: 12px، font-weight 700
  - shadow: 0 4px 12px rgba(0,0,0,0.2)

- **أزرار الإجراءات (Action Buttons)**:
  - عدد: 3 أزرار (عرض سريع، مقارنة، مفضلة)
  - شكل: دائري (46px × 46px)
  - خلفية: أبيض مع shadow
  - تظهر: عند hover أو دائماً على الموبايل
  - موضع: في منتصف الصورة
  - animation: fade in + scale
  - hover effect: تكبير + تغيير لون للذهبي

- **معلومات المنتج**:
  - padding: 16-18px
  - **الماركة/الفئة**: 
    - حجم: 13px
    - لون: رمادي فاتح
    - uppercase + letter-spacing
  
  - **اسم المنتج**:
    - حجم: 16px، font-weight 700
    - سطرين كحد أقصى (line-clamp: 2)
    - min-height: 44px
    - hover: يتحول للذهبي
  
  - **التقييم**:
    - نجوم ذهبية: font-size 13px
    - عدد التقييمات بين قوسين
  
  - **السعر**:
    - السعر القديم: مشطوب، 14px، رمادي
    - السعر الحالي: 20px، font-weight 800

- **زر إضافة للسلة**:
  - عرض: 100%
  - ارتفاع: 50px
  - خلفية: gradient ذهبي (#CCBF79 → #a89958)
  - شكل: 3 أقسام:
    ```
    [السعر] [خط فاصل] [أضف للسلة] [🛒]
    ```
  - hover: يتحول لدرجة أغمق + يرتفع قليلاً
  - shadow: 0 4px 12px rgba(gold, 0.3)

---

## 🎭 النوافذ المنبثقة والأدراج (Modals & Drawers)

### 1. Quick View Modal (العرض السريع)
```
┌─────────────────────────────────────────────────┐
│ عرض سريع                                 [×]   │
├─────────────┬───────────────────────────────────┤
│             │  Brand Name                       │
│             │  اسم المنتج                       │
│   [صورة]    │  ⭐⭐⭐⭐⭐ (125 تقييم)             │
│   المنتج    │  وصف المنتج هنا...                │
│             │                                   │
│             │  ~~950,000~~ 850,000 د.ع         │
│             │                                   │
│             │  الخيارات: [S] [M] [L] [XL]      │
│             │                                   │
│             │  الكمية: [-] 1 [+]  [❤️] [📤]   │
│             │                                   │
│             │  ┌─────────────────────────────┐ │
│             │  │ إضافة للسلة │ 850,000 د.ع  │ │
│             │  └─────────────────────────────┘ │
└─────────────┴───────────────────────────────────┘
```

**مواصفات:**
- عرض: 920px max
- ارتفاع: 90vh max
- خلفية: overlay شفاف مع blur
- animation: scale in من 0.9 إلى 1
- تقسيم: نصفين (صورة + تفاصيل)

### 2. Cart Drawer (درج السلة)
```
┌──────────────────────────────────┐
│ سلة التسوق [2]            [×]   │
├──────────────────────────────────┤
│                                  │
│ ┌────────────────────────────┐  │
│ │ [صورة] جوارب قطنية        │  │
│ │        5 حبات              │  │
│ │        [-] 1 [+]   15,000  │🗑│
│ └────────────────────────────┘  │
│                                  │
│ ┌────────────────────────────┐  │
│ │ كوبونات متاحة ▼           │  │
│ │ SAVE5K  - خصم 5,000        │  │
│ │ SAVE10K - خصم 10,000       │  │
│ └────────────────────────────┘  │
│                                  │
│ [شريط تقدم الشحن المجاني]      │
│ 24% - تبقى 76,500 للشحن المجاني│
│                                  │
├──────────────────────────────────┤
│ المجموع الفرعي:      23,500 د.ع │
│ الخصم:               -5,000 د.ع │
│ الشحن:               مجاني      │
│ ─────────────────────────────── │
│ الإجمالي:           28,500 د.ع │
│                                  │
│ [عرض السلة]  [إتمام الطلب]     │
└──────────────────────────────────┘
```

**مواصفات:**
- عرض: 420px
- موضع: من اليمين (RTL)
- animation: slide in من الجانب
- خلفية: overlay داكن 55% opacity
- قابل للتمرير (scrollable)

### 3. Wishlist Drawer (درج المفضلة)
```
┌──────────────────────────────────┐
│ المفضلة [5]               [×]   │
├──────────────────────────────────┤
│                                  │
│ ┌────────────────────────────┐  │
│ │ [صورة] جوارب حريرية      │  │
│ │        15,000 د.ع          │  │
│ │        [أضف للسلة]    [🗑] │  │
│ └────────────────────────────┘  │
│                                  │
│ (تكرار لباقي العناصر...)        │
│                                  │
├──────────────────────────────────┤
│ [إضافة الكل للسلة]              │
└──────────────────────────────────┘
```

---

## 🎬 الحركات والتفاعلات (Animations & Interactions)

### 1. تأثيرات Hover
- **البطاقات**: 
  - ترتفع: translateY(-6px)
  - shadow يزداد: 0 12px 40px rgba(0,0,0,0.15)
  - border يتحول للذهبي
  - الصورة تتكبر: scale(1.1)

- **الأزرار**:
  - تتكبر قليلاً: scale(1.05)
  - shadow يزداد
  - gradient يتحول لدرجة أغمق

- **الأيقونات**:
  - دوران 360 درجة (للمفضلة)
  - pulse effect (للسلة عند الإضافة)

### 2. الانتقالات (Transitions)
- **مدة قياسية**: 0.4s
- **easing**: cubic-bezier(0.4, 0, 0.2, 1)
- **الصور**: 0.6s للسلاسة

### 3. Animations
```css
@keyframes fadeInUp {
  from {
    opacity: 0;
    transform: translateY(30px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

@keyframes scaleIn {
  from {
    opacity: 0;
    transform: scale(0.9);
  }
  to {
    opacity: 1;
    transform: scale(1);
  }
}

@keyframes pulse {
  0%, 100% { transform: scale(1); }
  50% { transform: scale(1.1); }
}
```

---

## 📱 التصميم المتجاوب (Responsive Design)

### Desktop (> 1200px)
- 4 منتجات في الصف
- كاروسيل يعرض 4 منتجات
- القوائم الجانبية visible
- Hover effects كاملة

### Tablet (768px - 1200px)
- 3 منتجات في الصف
- كاروسيل يعرض 3 منتجات
- القوائم في hamburger menu

### Mobile (< 768px)
- **1.25 منتج في الصف** (منتج + ربع المنتج القادم)
- كاروسيل يعرض 1.25 منتج
- أزرار الإجراءات ظاهرة دائماً
- Navigation في bottom bar
- الأسعار والخطوط أصغر
- Quick view يكون full screen

---

## 🎯 عناصر UI مميزة

### 1. شريط التقدم (Progress Bar)
```
[███████░░░░░░░░░░] 24%
تبقى 76,500 د.ع للشحن المجاني 🚚
```
- gradient fill من الذهبي
- animated on change
- icon truck يتحرك مع التقدم

### 2. Badges & Tags
```
[خصم 12%]  [جديد]  [رائج]  [قابل للتخصيص ✨]
```
- ألوان مميزة لكل نوع
- shadows للعمق
- font-weight 700

### 3. Rating Stars
```
★★★★☆ (4.5) - 125 تقييم
```
- نجوم ذهبية ممتلئة
- نصف نجمة للكسور
- عدد التقييمات بلون رمادي

### 4. Toast Notifications
```
┌──────────────────────────┐
│ ✓ تمت الإضافة للسلة     │
└──────────────────────────┘
```
- تظهر من الأعلى
- تختفي بعد 3 ثوان
- icon + نص
- خلفية خضراء للنجاح / حمراء للخطأ

---

## 🖼️ Typography (الخطوط)

### الخطوط المستخدمة
```
font-family: 
  'Cairo', 
  'Noto Kufi Arabic', 
  system-ui, 
  -apple-system, 
  sans-serif;
```

### أحجام الخطوط
- **H1 (Hero)**: 52px / font-weight 800
- **H2 (Sections)**: 36px / font-weight 700
- **H3 (Cards)**: 16px / font-weight 700
- **Body**: 14px / font-weight 400
- **Small**: 12-13px / font-weight 500

### الأوزان
- Light: 300
- Regular: 400
- Medium: 500
- SemiBold: 600
- Bold: 700
- ExtraBold: 800
- Black: 900

---

## 🎨 Shadows & Effects

### Box Shadows
```css
--sh-sm: 0 2px 8px rgba(0, 0, 0, 0.1);
--sh-md: 0 4px 12px rgba(0, 0, 0, 0.15);
--sh-lg: 0 12px 40px rgba(0, 0, 0, 0.15);
--sh-gold: 0 4px 12px rgba(204, 191, 121, 0.3);
```

### Backdrop Blur
```css
backdrop-filter: blur(10px);
background: rgba(26, 26, 26, 0.8);
```

### Gradients
```css
/* زر ذهبي */
background: linear-gradient(135deg, #CCBF79 0%, #a89958 100%);

/* badge خصم */
background: linear-gradient(135deg, #e53e3e 0%, #c53030 100%);

/* تخصيص */
background: linear-gradient(135deg, #8b4789 0%, #6b3568 100%);
```

---

## 📐 Spacing System

```
--sp-xs:  4px
--sp-sm:  8px
--sp-md:  16px
--sp-lg:  24px
--sp-xl:  32px
--sp-2xl: 48px
--sp-3xl: 64px
```

### Border Radius
```
--r-sm:  4px
--r-md:  8px
--r-lg:  16px
--r-xl:  24px
--r-full: 9999px (دائري كامل)
```

---

## 🎪 الكاروسيل (Carousel)

```
[◀] [منتج 1] [منتج 2] [منتج 3] [منتج 4] [▶]
     ● ○ ○ ○
```

**مواصفات:**
- أسهم تظهر عند hover
- dots indicators في الأسفل
- swipe support على الموبايل
- auto-scroll كل 5 ثوان (optional)
- smooth transitions

---

## 🌟 نصائح للتنفيذ

### 1. الأداء
- lazy loading للصور
- progressive image loading
- debounce للبحث
- virtual scrolling للقوائم الطويلة

### 2. الوصول (Accessibility)
- alt text للصور
- ARIA labels للأزرار
- keyboard navigation
- focus indicators واضحة
- contrast ratio مناسب

### 3. التحسينات
- skeleton loading states
- error states واضحة
- empty states جميلة
- loading spinners مع brand colors

---

## 🎬 User Journey

### مسار شراء منتج:
1. **الصفحة الرئيسية** → يرى Hero + المنتجات المميزة
2. **Hover على بطاقة** → تظهر الأزرار + الصورة تتكبر
3. **ضغط على عرض سريع (👁️)** → Quick View Modal يفتح
4. **اختيار الخيارات** → الحجم، اللون، الكمية
5. **إضافة للسلة** → Toast notification + Cart Drawer يفتح
6. **مراجعة السلة** → شريط تقدم الشحن + كوبونات
7. **إتمام الطلب** → checkout page

### مسار المفضلة:
1. ضغط على ❤️ → Toast + Wishlist Drawer يفتح
2. رؤية جميع المفضلة
3. إضافة للسلة أو الحذف

---

## 📱 Mobile-First Considerations

### الأولويات على الموبايل:
1. **السرعة**: تحميل سريع، صور مضغوطة
2. **البساطة**: UI مبسط، أزرار كبيرة
3. **الوضوح**: نصوص واضحة، تباين عالي
4. **سهولة اللمس**: أزرار 44px+ minimum
5. **التمرير**: smooth scrolling، scroll snap

### Bottom Navigation Bar
```
[🏠 الرئيسية] [🛍️ المتجر] [❤️ المفضلة] [👤 حسابي]
```
- ثابت في الأسفل
- icons + labels
- active state واضح
- background blur

---

## 🎨 Design Tokens Summary

```json
{
  "colors": {
    "primary": "#CCBF79",
    "secondary": "#8b4789",
    "danger": "#e53e3e",
    "success": "#38a169",
    "dark": "#1a1a1a",
    "light": "#f5f5f5"
  },
  "spacing": [4, 8, 16, 24, 32, 48, 64],
  "borderRadius": [4, 8, 16, 24],
  "fontSizes": [12, 13, 14, 16, 20, 22, 28, 36, 52],
  "fontWeights": [300, 400, 500, 600, 700, 800, 900],
  "shadows": {
    "sm": "0 2px 8px rgba(0,0,0,0.1)",
    "md": "0 4px 12px rgba(0,0,0,0.15)",
    "lg": "0 12px 40px rgba(0,0,0,0.15)"
  },
  "transitions": {
    "fast": "0.2s",
    "normal": "0.4s",
    "slow": "0.6s"
  }
}
```

---

## 🎯 الخلاصة

التصميم يجمع بين:
- ✨ **الفخامة**: ألوان ذهبية، تدرجات، shadows عميقة
- 🎨 **الحداثة**: تصميم clean، مساحات بيضاء، typography واضح
- 🚀 **الأداء**: animations سلسة، transitions ناعمة
- 📱 **التجاوب**: يعمل بشكل مثالي على جميع الأجهزة
- 🎭 **التفاعلية**: hover effects، modals، drawers
- 🌍 **العالمية**: RTL support، Arabic typography

---

**تم إنشاء هذا الوصف لمتجر نساج الإلكتروني**
التصميم يعكس هوية العلامة التجارية العراقية الفاخرة للمنسوجات والجوارب 🇮🇶
