<?php
get_header(); ?>

    <main id="main" class="site-main" role="main">
        <?php
        /* Start the Loop */

        $gallery_columns = get_theme_mod('osf_portfolio_single_gallery_columns', '3');
        while (have_posts()) : the_post();
            ?>
            <div class="row single-portfolio-row">
                <div class="col-12 single-portfolio-gallery text-center">
                    <!--                    <div class="single-portfolio-gallery-columns gallery-columns-3 ">-->
                    <div class="owl-theme owl-carousel portfolio-popup-gallery" data-opal-carousel="true" data-dots="true" data-nav="false"
                         data-items="3" data-loop="false" data-margin="30">
                        <?php
                        if (has_post_thumbnail()) {
                            echo '<a data-elementor-open-lightbox="no" href="' . get_the_post_thumbnail_url() . '" title="' . get_the_title() . '">';
                            the_post_thumbnail('konstruktic-featured-image-large');
                            echo '</a>';
                        }
                        $gallery = osf_get_metabox(get_the_ID(), 'osf_portfolio_gallery');

                        if (!empty($gallery)) {
                            foreach ((array)$gallery as $attachment_id => $attachment_url) {
                                echo '<a data-elementor-open-lightbox="no" href="' . $attachment_url . '" title="'. get_post_meta($attachment_id, '_wp_attachment_image_alt', TRUE).'">';
                                echo wp_get_attachment_image($attachment_id, 'konstruktic-featured-image-large');
                                echo '</a>';
                            }
                        }
                        ?>
                    </div>
                </div>
                <div class="col-12 single-portfolio-summary">
                    <div class="single-portfolio-summary-inner">
                        <div class="single-portfolio-summary-meta">
                            <div class="single-portfolio-summary-meta-inner">
                                <h3 class="single-portfolio-summary-meta-title"><?php echo esc_html__('Project info', 'konstruktic'); ?></h3>
                                <ul class="single-portfolio-summary-meta-list">
                                    <?php echo '<li><label>' . esc_html__('Category ', 'konstruktic') . '</label>' . OSF_Custom_Post_Type_Portfolio::getInstance()->get_term_portfolio(get_the_ID()) . '</li>'; ?>
                                    <?php
                                    $entries = get_post_meta(get_the_ID(), 'osf_portfolio_repeat_group', true);
                                    foreach ((array)$entries as $key => $entry) {
                                        $title = $desc = '';
                                        if (isset($entry['title'])) {
                                            $title = $entry['title'];
                                        }
                                        if (isset($entry['description'])) {
                                            $desc = wpautop($entry['description']);
                                        }
                                        echo '<li><label>' . esc_html($title) . '</label>' . wp_kses_post($desc) . '</li>';
                                    }
                                    ?>
                                </ul>
                                <?php konstruktic_social_share(); ?>
                            </div>
                        </div>
                        <div class="single-portfolio-summary-content">
                            <div class="single-portfolio-summary-content-inner">
                                <?php the_content(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            $obj = konstruktic_get_post_link('osf_portfolio_cat', 'osf_portfolio');
            $prev_link = $obj->previous_post;
            $next_link = $obj->next_post;

            if (!empty($prev_link) || !empty($next_link)):
                ?>
                <div class="single-portfolio-navigation">
                    <?php if (!empty($prev_link)): ?>
                        <div class="previous-nav">
                            <div class="nav-link">
                                <i class="opal-icon-long-arrow-left"></i><?php echo wp_kses_post($prev_link); ?>
                                <span><?php echo esc_html__('Previous Project', 'konstruktic') ?></span></div>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($next_link)): ?>
                        <div class="next-nav">
                            <div class="nav-link"><?php echo wp_kses_post($next_link); ?>
                                <span><?php echo esc_html__('Next Project', 'konstruktic') ?></span><i
                                        class="opal-icon-long-arrow-right"></i></div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        <?php
        endwhile; // End of the loop.
        OSF_Custom_Post_Type_Portfolio::getInstance()->konstruktic_fnc_related_portfolio();
        ?>

    </main><!-- #main -->

<?php get_footer();
