<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! osf_is_elementor_activated() ) {
	return;
}

use Elementor\Controls_Manager;

class OSF_Vertical_Line {


	public function __construct() {
		add_action( 'customize_register', array( $this, 'customize_register' ) );

		$this->render_html();
		add_filter( 'osf_theme_custom_inline_css', array( $this, 'render_css' ) );

		add_action( 'elementor/element/section/section_layout/after_section_end', [
			$this,
			'register_controls'
		], 10, 2 );

		add_filter('body_class', [$this, 'check_vertical_line']);
	}

	public function check_vertical_line($classes){
		if(!get_theme_mod('osf_vertical_line_switch', true)){
			$classes[] = 'opal-diable-vertical-line';
		}
		return $classes;
	}
	public function customize_register( $wp_customize ) {
		if ( class_exists( 'OSF_Customize_Control_Button_Switch' ) ) {
			$wp_customize->add_setting( 'osf_vertical_line_switch', array(
				'default'           => '1',
				'sanitize_callback' => 'osf_sanitize_button_switch',
			) );
			$wp_customize->add_control( new OSF_Customize_Control_Button_Switch( $wp_customize, 'osf_vertical_line_switch', array(
				'section' => 'osf_layout_general',
				'label'   => __( 'Enable Vertical Line', 'konstruktic-core' ),
			) ) );
		}

		if ( class_exists( 'OSF_Customize_Control_Color' ) ) {
			$wp_customize->add_setting( 'osf_vertical_line_color', array(
				'default'           => '#f2f2f2',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'maybe_hash_hex_color',
			) );
			$wp_customize->add_control( new OSF_Customize_Control_Color( $wp_customize, 'osf_vertical_line_color', array(
				'section' => 'osf_layout_general',
				'label'   => __( 'Vertical Line Color', 'konstruktic-core' ),
			) ) );
		}
	}

	public function render_html() {
		if ( get_theme_mod( 'osf_vertical_line_switch' ) == 1 ) {
			add_action( 'wp_footer', function () {
				echo '<div class="vertical-lines"><div class="container-wrap"><div class="line-wrap"><div class="line-item line-1"></div><div class="line-item line-2"></div></div></div></div>';
			} );
		}
	}

	public function render_css( $css ) {
		if ( ! empty( get_theme_mod( 'osf_vertical_line_color' ) ) && get_theme_mod( 'osf_vertical_line_color' ) !== '#f2f2f2' ) {
			$css .= '.vertical-lines .line-item { background-color:' . get_theme_mod( 'osf_vertical_line_color' ) . ';} .vertical-lines .line-wrap{ border-color: ' . get_theme_mod( 'osf_vertical_line_color' ) . ';}';
		}

		return $css;
	}

	public function register_controls( $element, $args ) {

		$element->start_controls_section(
			'osf_section_vertical_line',
			[
				'label' => __( 'Vertical Line', 'konstruktic-core' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			]
		);

		$element->add_control( 'osf_section_vertical_line_switcher',
			[
				'label'              => __( 'Enable Vertical Line', 'konstruktic-core' ),
				'type'               => Controls_Manager::SWITCHER,
				'default'            => '',
				'frontend_available' => true,
				'label_on'           => 'Yes',
				'label_off'          => 'No',
				'return_value'       => 'active',
				'prefix_class'       => 'osf-vertical-line-'
			]
		);

		$element->add_control( 'osf_section_vertical_line_color',
			[
				'label'     => __( 'Color', 'konstruktic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vertical-lines .line-wrap' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .vertical-lines .line-item' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'osf_section_vertical_line_switcher' => 'active'
				]
			]
		);

		$element->end_controls_section();

	}

}

new OSF_Vertical_Line();