<?php

use Elementor\Group_Control_Css_Filter;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;

use Elementor\Group_Control_Typography;

use Elementor\Group_Control_Image_Size;

class OSF_Elementor_Slider_Box extends OSF_Elementor_Carousel_Base
{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'opal-slider-box';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Opal Slider Box', 'konstruktic-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    public function get_categories()
    {
        return array('opal-addons');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'section_slider_box',
            [
                'label' => __('Slider Box', 'konstruktic-core'),
            ]
        );

        $repeater = new Elementor\Repeater();

        $repeater->add_control(
            'slider',
            [
                'label' => __('Slider Box Item', 'konstruktic-core'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __('Image', 'konstruktic-core'),
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default' => 'full',
                'separator' => 'none',
            ]
        );

        $repeater->add_control(
            'view',
            [
                'label' => __('View', 'konstruktic-core'),
                'type' => Controls_Manager::HIDDEN,
                'default' => 'traditional',
            ]
        );

        $repeater->add_control(
            'number',
            [
                'label' => __('Number', 'konstruktic-core'),
                'default' => '01',
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => __('Name', 'konstruktic-core'),
                'default' => 'Effective teamwork',
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => __('Description', 'konstruktic-core'),
                'default' => 'Construction as an industry comprises six to nine percent of the gross domestic product of developed countries. In general, there are three sectors of construction.',
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __('Link to', 'konstruktic-core'),
                'placeholder' => __('https://your-link.com', 'konstruktic-core'),
                'default' => [
                    'url' => '#',
                ],
                'type' => Controls_Manager::URL,
            ]
        );

        $this->add_control(
            'slider_box_items',
            [
                'label' => __('Slider Box Items', 'konstruktic-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();


        // Wrapper
        $this->start_controls_section(
            'section_style_wrapper',
            [
                'label' => __('Wrapper', 'konstruktic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'wrapper_padding',
            [
                'label' => __( 'Padding', 'konstruktic-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'tabs_wrapper_style' );

        $this->start_controls_tab(
            'tab_wrapper_normal',
            [
                'label' => __( 'Normal', 'konstruktic-core' ),
            ]
        );

        $this->add_control(
            'bg_wrapper',
            [
                'label' => __( 'Background Color', 'konstruktic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_wrapper_hover',
            [
                'label' => __( 'Hover', 'konstruktic-core' ),
            ]
        );

        $this->add_control(
            'bg_wrapper_hover',
            [
                'label' => __( 'Background Color', 'konstruktic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-item.active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();


        // Number
        $this->start_controls_section(
            'section_style_number',
            [
                'label' => __('Number', 'konstruktic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} .elementor-slider-box-number',
            ]
        );

        $this->start_controls_tabs( 'tabs_number_style' );

        $this->start_controls_tab(
            'tab_number_normal',
            [
                'label' => __( 'Normal', 'konstruktic-core' ),
            ]
        );

        $this->add_control(
            'color_number',
            [
                'label' => __( 'Color', 'konstruktic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-item .elementor-slider-box-number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'stroke_color_number',
            [
                'label' => __( 'Stroke Color', 'konstruktic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-item .elementor-slider-box-number' => '-webkit-text-stroke-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_number_hover',
            [
                'label' => __( 'Hover', 'konstruktic-core' ),
            ]
        );

        $this->add_control(
            'color_number_hover',
            [
                'label' => __( 'Color', 'konstruktic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-item.active .elementor-slider-box-number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'stroke_color_number_hover',
            [
                'label' => __( 'Stroke Color', 'konstruktic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-item.active .elementor-slider-box-number' => '-webkit-text-stroke-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Name
        $this->start_controls_section(
            'section_style_name',
            [
                'label' => __('Name', 'konstruktic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .elementor-slider-box-name',
            ]
        );

        $this->start_controls_tabs( 'tabs_name_style' );

        $this->start_controls_tab(
            'tab_name_normal',
            [
                'label' => __( 'Normal', 'konstruktic-core' ),
            ]
        );

        $this->add_control(
            'color_name',
            [
                'label' => __( 'Color', 'konstruktic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-name:not(:hover)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_name_hover',
            [
                'label' => __( 'Hover', 'konstruktic-core' ),
            ]
        );

        $this->add_control(
            'color_name_hover',
            [
                'label' => __( 'Color', 'konstruktic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-name:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Description
        $this->start_controls_section(
            'section_style_description',
            [
                'label' => __('Description', 'konstruktic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color_description',
            [
                'label' => __( 'Color', 'konstruktic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-box-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Carousel Option
        $this->add_control_carousel();

    }

    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('wrapper', 'class', 'elementor-slider-box-wrapper');


        // Item
        $this->add_render_attribute('item', 'class', '');

        $this->add_render_attribute('meta', 'class', 'elementor-slider-box-meta');

        $this->add_render_attribute('row', 'class', 'row');


        // carousel 2
        $this->add_render_attribute('row2', 'class', 'owl-carousel owl-theme');
        $carousel_settings = array(
            'navigation' => $settings['navigation'],
            'autoplayHoverPause' => $settings['pause_on_hover'] === 'yes' ? 'true' : 'false',
            'autoplay' => $settings['autoplay'] === 'yes' ? 'true' : 'false',
            'autoplayTimeout' => $settings['autoplay_speed'],
            'items' => 1,
            'items_tablet' => 1,
            'items_mobile' => 1,
            'loop' => $settings['infinite'] === 'yes' ? 'true' : 'false',

        );
        $this->add_render_attribute('row2', 'data-settings', wp_json_encode($carousel_settings));

        ?>
        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
            <div class="elementor-slider-box-img">
                <div <?php echo $this->get_render_attribute_string('row2') ?>>
                     <?php foreach ($settings['slider_box_items'] as $index => $item) : ?>
                         <div class="elementor-slider-box-image" data-trigger="<?php echo '.tes-item-' . esc_attr($item['_id']); ?>">
                             <?php
                             $image_html = Group_Control_Image_Size::get_attachment_image_html($item, 'thumbnail', 'image');
                             echo $image_html;
                             ?>
                         </div>
                     <?php endforeach; ?>
                </div>
            </div>
            <div class="elementor-slider-box-content-wrapper">
                <?php foreach ($settings['slider_box_items'] as $index => $item) : ?>
                    <div class="elementor-slider-box-item <?php echo 'tes-item-' . esc_attr($item['_id']); ?>" data-index="<?php echo esc_attr($index) ?>">
                        <div class="elementor-slider-box-meta-inner">
                            <div class="item-box">
                                <div class="elementor-slider-box-content">
                                    <?php
                                    $slider_box_number = $item['number'];
                                    $slider_box_name = $item['name'];
                                    $slider_box_description = $item['description'];
//                                    if (!empty($item['link']['url'])) :
//                                        $slider_box_name = '<a href="' . esc_url($item['link']['url']) . '">' . $slider_box_name . '</a>';
//                                    endif;
                                    ?>
                                    <div class="elementor-slider-box-number"><?php echo $slider_box_number; ?></div>
                                    <div class="elementor-slider-box-name"><?php echo $slider_box_name; ?></div>
                                    <div class="elementor-slider-box-description"><?php echo $slider_box_description; ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }


}

$widgets_manager->register(new OSF_Elementor_Slider_Box());
