<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!osf_is_revslider_activated()) {
    return;
}

use Elementor\Controls_Manager;

class OSF_Elementor_RevSlider extends Elementor\Widget_Base
{

    public function get_name()
    {
        return 'opal-revslider';
    }

    public function get_title()
    {
        return __('Opal Revolution Slider', 'konstruktic-core');
    }

    public function get_categories()
    {
        return array('opal-addons');
    }

    public function get_icon()
    {
        return 'eicon-slider-push';
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'rev_slider',
            [
                'label' => __('General', 'konstruktic-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'rev_alias',
            [
                'label' => __('Revolution Slider', 'konstruktic-core'),
                'type' => Controls_Manager::SELECT,
                'options' => $this->get_revslider_data(),
                'default' => ''
            ]
        );

        $this->add_control('osf_section_vertical_line_switcher',
            [
                'label' => __('Enable Vertical Line', 'konstruktic-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => '',
                'frontend_available' => true,
                'label_on' => 'Yes',
                'label_off' => 'No',
                'return_value' => 'active',
                'prefix_class' => 'osf-vertical-line-'
            ]
        );

        $this->add_control('osf_section_vertical_line_color',
            [
                'label' => __('Color', 'konstruktic-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vertical-lines .line-wrap' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .vertical-lines .line-item' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'osf_section_vertical_line_switcher' => 'active'
                ]
            ]
        );

        $this->end_controls_section();
    }

    public function get_revslider_data()
    {
        $slider = new RevSlider();
        $arrSliders = $slider->getArrSliders();

        $revsliders = array();
        if ($arrSliders) {
            foreach ($arrSliders as $slider) {
                /** @var $slider RevSlider */
                $revsliders[$slider->getAlias()] = $slider->getTitle();
            }
        } else {
            $revsliders[0] = __('No sliders found', 'konstruktic-core');
        }

        return $revsliders;

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (!$settings['rev_alias']) {
            return;
        }


        echo apply_filters('opal_revslider_shortcode', do_shortcode('[rev_slider ' . $settings['rev_alias'] . ']'));

    }
}

$widgets_manager->register(new OSF_Elementor_RevSlider());