<?php

class OSF_WP_Widget_Recent_Posts extends WP_Widget_Recent_Posts {

    public function widget($args, $instance) {
        if (!isset($args['widget_id'])) {
            $args['widget_id'] = $this->id;
        }

        $title = (!empty($instance['title'])) ? $instance['title'] : __('Recent Posts', 'konstruktic-core');

        $title = apply_filters('widget_title', $title, $instance, $this->id_base);

        $number = (!empty($instance['number'])) ? absint($instance['number']) : 5;
        if (!$number) {
            $number = 5;
        }
        $show_date = isset($instance['show_date']) ? $instance['show_date'] : false;

        $r = new WP_Query(apply_filters('widget_posts_args', array(
            'posts_per_page'      => $number,
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
        ), $instance));

        if (!$r->have_posts()) {
            return;
        }
        ?>
        <?php echo $args['before_widget']; ?>
        <?php
        if ($title) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        ?>
        <ul>
            <?php foreach ($r->posts as $recent_post) : ?>
                <?php
                $post_title = get_the_title($recent_post->ID);
                $title = (!empty($post_title)) ? $post_title : __('(no title)', 'konstruktic-core');
                ?>
                <li class="item-recent-post">
                    <?php if (has_post_thumbnail($recent_post->ID)): ?>
                        <div class="thumbnail-post"><?php echo get_the_post_thumbnail($recent_post->ID, 'thumbnail'); ?></div>
                    <?php endif; ?>
                    <div class="title-post">
                        <a href="<?php the_permalink($recent_post->ID); ?>"><?php echo $title; ?></a>
                        <?php if ($show_date) : ?>
                            <span class="post-date"><?php echo get_the_date('', $recent_post->ID); ?></span>
                        <?php endif; ?>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
        <?php
        echo $args['after_widget'];
    }
}

class OSF_Widget_Rooms_Cat extends WP_Widget
{


    public function __construct()
    {
        $widget_ops = array(
            'classname' => 'widget_rooms_cat',
            'description' => __('Show rooms categories', 'konstruktic-core'),
            'customize_selective_refresh' => true,
        );
        parent::__construct('widget_rooms_cat', __('Rooms Categories', 'konstruktic-core'), $widget_ops);
        $this->alt_option_name = 'widget_rooms_cat';
    }


    public function widget($args, $instance)
    {
        if (!isset($args['widget_id'])) {
            $args['widget_id'] = $this->id;
        }

        $title = (!empty($instance['title'])) ? $instance['title'] : __('Rooms Categories', 'konstruktic-core');

        $title = apply_filters('widget_title', $title, $instance, $this->id_base);

        $categories = get_terms(array(
                'taxonomy' => 'osf_room_cat',
                'hide_empty' => false,
            )
        );
        $results = array();
        if (is_wp_error($categories)) {
            return;
        }
        foreach ($categories as $category) {
            $results[$category->slug] = $category->name;
        }


        ?>
        <?php echo $args['before_widget']; ?>
        <?php
        if ($title) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        ?>
        <ul>
            <?php foreach ($categories as $category): ?>
                <li class="item-cat-room">
                    <a href="<?php echo get_term_link($category->slug, 'osf_room_cat'); ?>"><?php echo esc_html($category->name); ?></a>
                </li>
            <?php endforeach; ?>
        </ul>
        <?php
        echo $args['after_widget'];
    }

    public function update($new_instance, $old_instance)
    {
        $instance = $old_instance;
        $instance['title'] = sanitize_text_field($new_instance['title']);
        return $instance;
    }

    public function form($instance)
    {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        ?>
        <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'konstruktic-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>"/></p>

        <?php
    }
}

function osf_widget_registration() {
    register_widget('OSF_WP_Widget_Recent_Posts');
    register_widget('OSF_Widget_Rooms_Cat');
}

add_action('widgets_init', 'osf_widget_registration');